//=============================================================================
// GreaselPet.
//=============================================================================
class BeetlePetRed extends DeusExPickup;

var localized String MsgNoHALP;

state Activated
{
	function Activate()
	{
	}

	function BeginState()
	{
		local DeusExPlayer P;
                		local Vector loc;
		local RedBeetleCompanion D;
	
		Super.BeginState(); 

                		P = DeusExPlayer(Owner);
                		if ( P != None )    
                		{            
                      		D = Spawn(Class'RedBeetleCompanion',P,,P.Location + (P.CollisionRadius+Class'DragonCompanion'.Default.CollisionRadius+30) * Vector(P.ViewRotation) + vect(0,0,1) * 30 );
			if ( D != None )
			{
                      			D.PlaySound(None);
                      			UseOnce();
			}
			else
			{
				P.ClientMessage(MsgNoHALP);
				GotoState('DeActivated');
			}
                		}
	}
Begin:
}

defaultproperties
{
     MsgNoHALP="|p2Beetle cannot be released here."
     bActivatable=True
     ItemName="|p2Beetle Pet"
     PlayerViewOffset=(X=20.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'Markistan.Beetle'
     PlayerViewScale=0.800000
     PickupViewMesh=LodMesh'Markistan.Beetle'
     ThirdPersonMesh=LodMesh'Markistan.Beetle'
     LandSound=Sound'DeusExSounds.Generic.MetalHit1'
     Icon=Texture'Markistan.Icons.BeltIconHALPAgent'
     largeIcon=Texture'Markistan.Icons.InventoryIconHALPAgent'
     largeIconWidth=49
     largeIconHeight=49
     Description="A small beetle that seems to like you..."
     beltDescription="|p2Beetle"
     Mesh=LodMesh'Markistan.Beetle'
     CollisionRadius=16.790001
     CollisionHeight=7.620000
     Mass=50.000000
     Buoyancy=100.000000
     MultiSkins(2)=Texture'BeetleShell2'
     MultiSkins(3)=Texture'BeetleShell2'
     MultiSkins(4)=Texture'BeetleShell2'
}
